import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor'

class ImageEditor {
  constructor() {
    this.title = '图片编辑';
    this.iconSvg = `<svg t="1709779981871" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="4253" width="48" height="48"><path d="M853.333333 501.333333c-17.066667 0-32 14.933333-32 32v320c0 6.4-4.266667 10.666667-10.666666 10.666667H170.666667c-6.4 0-10.666667-4.266667-10.666667-10.666667V213.333333c0-6.4 4.266667-10.666667 10.666667-10.666666h320c17.066667 0 32-14.933333 32-32s-14.933333-32-32-32H170.666667c-40.533333 0-74.666667 34.133333-74.666667 74.666666v640c0 40.533333 34.133333 74.666667 74.666667 74.666667h640c40.533333 0 74.666667-34.133333 74.666666-74.666667V533.333333c0-17.066667-14.933333-32-32-32z" fill="#595959" p-id="4254"></path><path d="M405.333333 484.266667l-32 125.866666c-2.133333 10.666667 0 23.466667 8.533334 29.866667 6.4 6.4 14.933333 8.533333 23.466666 8.533333h8.533334l125.866666-32c6.4-2.133333 10.666667-4.266667 14.933334-8.533333l300.8-300.8c38.4-38.4 38.4-102.4 0-140.8-38.4-38.4-102.4-38.4-140.8 0L413.866667 469.333333c-4.266667 4.266667-6.4 8.533333-8.533334 14.933334z m59.733334 23.466666L761.6 213.333333c12.8-12.8 36.266667-12.8 49.066667 0 12.8 12.8 12.8 36.266667 0 49.066667L516.266667 558.933333l-66.133334 17.066667 14.933334-68.266667z" fill="#595959" p-id="4255"></path></svg>`;
    this.tag = 'button';
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片';
  }
  isActive(editor) {
    return false; // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote') return true
    })
    if (hasPreElem) return true;

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if (this.isDisabled(editor)) {
      return;
    }
    editor.emit('ImageEditorClick');
  }
}

export default {
  key: 'ImageEditor', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ImageEditor(); // 把 `YourMenuClass` 替换为你菜单的 class
  },
};

export { ImageEditor };
