import React, { useState } from 'react';
import { Divider, Button, Spin, Modal, Row, Col, Space } from 'antd';
import { CloseOutlined } from '@ant-design/icons';
import { Editor, Toolbar } from '@wangeditor/editor-for-react';
import { getRecordList, getRecordInfo } from '../utils/request';
import './index.less';
import { useEffect } from 'react';

const HistoryEditor = (props) => {
  const { setHistoryVisible, chapterId, bookId, setContent, saveContent } = props;

  const [loading, setLoading] = useState(false);
  const [delMoadal, setDelModal] = useState(false);
  const [recordContent, setRecordContent] = useState(''); // 内容
  const [recordList, setRecordList] = useState([]); // 列表
  const [recordId, setRecordId] = useState(null); // 当前的记录id

  // 确认还原
  const handleSuccess = () => {
    setContent(recordContent);
    saveContent();
    setDelModal(false);
    setHistoryVisible(false);
  };

  // 获取历史记录
  const getRecordListVal = async () => {
    setLoading(true);
    const data = await getRecordList({
      chapter_id: chapterId,
      page: 1,
      pagesize: 10,
      book_id: bookId,
    });
    if (data.length > 0) {
      setRecordList(data);
      await getRecordInfoVal(data[0].name);
    }
    setLoading(false);
  };

  // 获取历史详情
  const getRecordInfoVal = async (name) => {
    setLoading(true);
    const data = await getRecordInfo({
      chapter_id: chapterId,
      book_id: bookId,
      name: name || recordId,
    });
    if (name) {
      setRecordId[name];
    }
    setRecordContent(data.content);
    setLoading(false);
  };

  useEffect(() => {
    getRecordListVal();
  }, [chapterId, bookId]);

  useEffect(() => {
    if (recordId) {
      getRecordInfoVal();
    }
  }, [recordId]);

  return (
    <div className='history-content-container'>
      <div className='left'>
        <div className='left-content'>
          <Spin spinning={loading}>
            <div className='conent' dangerouslySetInnerHTML={{ __html: recordContent }}></div>
          </Spin>
        </div>
      </div>

      <div className='right'>
        <div className='top'>
          <div className='top-left'>
            <strong>历史记录</strong>
          </div>
          <div className='icon'>
            <CloseOutlined
              style={{ fontSize: 20, color: '#b1b1b1' }}
              onClick={() => setHistoryVisible(false)}
            />
          </div>
        </div>

        <div className='buttom'>
          {recordList && recordList.length > 0 ? (
            recordList.map((item, index) => {
              return (
                <div
                  className={`son ${recordId === item.name ? 'active' : ''}`}
                  key={index}
                  onClick={() => {
                    setRecordId(item.name);
                  }}
                >
                  <div className='left1'>
                    <div className='text'>{index === 0 ? '当前版本' : item.title}</div>
                    <div className='time'>{item.time}</div>
                  </div>
                  {index !== 0 && (
                    <div className='right-btn'>
                      <Button
                        className='text'
                        onClick={() => {
                          setRecordId(item.name);
                          setDelModal(true);
                        }}
                      >
                        还原
                      </Button>
                    </div>
                  )}
                </div>
              );
            })
          ) : (
            <div className='son'>
              <div className='left1'>
                <div className='text'>当前版本</div>
                <div className='time'>暂无发布时间</div>
              </div>
            </div>
          )}
        </div>
      </div>

      {/* 历史--点击还原之前的提示 */}
      <Modal
        mask={false}
        centered
        className='history2'
        open={delMoadal}
        onOk={handleSuccess}
        onCancel={() => setDelModal(false)}
        footer={(_, { OkBtn, CancelBtn }) => {
          return (
            <Row justify={'center'} className='delModal' style={{ marginBottom: '30px' }}>
              <Space size={20}>
                <CancelBtn className='cancel' />
                <OkBtn className='true' />
              </Space>
            </Row>
          );
        }}
        okText='确认'
        style={{
          position: 'absolute',
          top: '33%',
          left: '36%',
          padding: '10px',
          zIndex: 1000,
        }}
      >
        <p style={{ textAlign: 'center', padding: '30px 0 18px', fontSize: 16 }}>
          确认还原吗？还原后会覆盖当前版本
        </p>
      </Modal>
    </div>
  );
};

export default HistoryEditor;
