import BaseModalMenu from './common/BaseModalMenu'
import AIModal from './common/AIModal'
class AIExpand extends BaseModalMenu {
  constructor() {
    super()
    this.title = '扩写'
    this.iconSvg = `<svg width="48px" height="48px" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-622, -216)" fill="#333333" fill-rule="nonzero">
            <g id="文章扩写" transform="translate(622, 216)">
                <path d="M13.7129132,15.0769457 C14.955546,15.0769457 15.962899,16.2614646 15.962899,17.7226427 L15.962899,28.8063497 L25.1788407,28.8063497 C26.4214735,28.8063497 27.4288264,29.9908686 27.4288264,31.4520467 C27.4288264,32.9132249 26.4214735,34.0977438 25.1788407,34.0977438 L15.959899,34.0977438 L15.959899,45.3543029 C15.959899,46.8154811 14.9525461,48 13.7099132,48 C12.4672804,48 11.4599275,46.8154811 11.4599275,45.3543029 L11.4599275,34.0977438 L2.24998577,34.0977438 C1.00735294,34.0977438 0,32.9132249 0,31.4520467 C0,29.9908686 1.00735294,28.8063497 2.24998577,28.8063497 L11.4629274,28.8063497 L11.4629274,17.7226427 C11.4629274,16.2614646 12.4702804,15.0769457 13.7129132,15.0769457 Z M45.7497105,41.1564636 C46.553553,41.1564636 47.2963341,41.6607305 47.6982554,42.4793121 C48.1001766,43.2978936 48.1001766,44.3064277 47.6982554,45.1250092 C47.2963341,45.9435908 46.553553,46.4478577 45.7497105,46.4478577 L33.1077905,46.4478577 C31.8651576,46.4478577 30.8578047,45.2633388 30.8578047,43.8021607 C30.8578047,42.3409825 31.8651576,41.1564636 33.1077905,41.1564636 L45.7497105,41.1564636 L45.7497105,41.1564636 Z M45.7497105,20.576468 C46.5536253,20.5763404 47.2965197,21.0805795 47.6985084,21.8992134 C48.1004972,22.7178473 48.1004972,23.7264828 47.6985084,24.5451167 C47.2965197,25.3637506 46.5536253,25.8679897 45.7497105,25.8678621 L29.6788122,25.8678621 C28.8748973,25.8679897 28.132003,25.3637506 27.7300142,24.5451167 C27.3280254,23.7264828 27.3280254,22.7178473 27.7300142,21.8992134 C28.132003,21.0805795 28.8748973,20.5763404 29.6788122,20.576468 L45.7497105,20.576468 L45.7497105,20.576468 Z M45.7497105,0 C46.9923433,0 47.9996962,1.18451893 47.9996962,2.64569707 C47.9996962,4.10687522 46.9923433,5.29139415 45.7497105,5.29139415 L2.24998577,5.29139415 C1.00735294,5.29139415 0,4.10687522 0,2.64569707 C0,1.18451893 1.00735294,0 2.24998577,0 L45.7497105,0 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`
  }
  getValue(editor) {
    return <AIModal key={Date.now()} editor={editor} action="expand"></AIModal>
  }
}

export default {
  key: 'AIExpand',
  factory() {
    return new AIExpand()
  }
}
