import { Menu } from 'antd'
import { useLocation } from 'react-router-dom'

export default function AppMenu({ menuList }) {
  const { pathname } = useLocation()
  const selectedKeys = menuList
    .filter(item => {
      const regExp = new RegExp(`^${item.path}`)
      return regExp.test(pathname)
    })
    .map(item => item.key)

  return (
    <div className="header-menu">
      <Menu
        className="menu"
        mode="horizontal"
        items={menuList}
        selectedKeys={selectedKeys}
        style={{ border: 'none' }}
        builtinPlacements={{
          bottomLeft: {
            points: ['tc', 'bc'], // 子菜单的 "上中" 和 对应菜单的title "下中" 对齐。
            overflow: { adjustX: 10, adjustY: 10 },
            offset: [0, 3] //让下拉菜单位移
          }
        }}
      />
    </div>
  )
}
