import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 用户信息
const getUserInfo = async (obj) => {
  try {
    const res = await axios.post('/user/user/getUserInfo', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 退出
const loginout = async (obj) => {
  try {
    const res = await axios.post('/login/out', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 菜单列表
const getMenuList = async (obj) => {
  try {
    const res = await axios.post('/system/power/getMenuList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const operation_permissions_list = get(res, 'data.operation_permissions_list', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return { data, operation_permissions_list };
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 修改密码
const changePass = async (obj) => {
  try {
    const res = await axios.post('/user/user/changePass', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改信息
const changeInfo = async (obj) => {
  try {
    const res = await axios.post('/user/user/editUserInfo', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 消息列表
const getMessageList = async (obj) => {
  try {
    const res = await axios.post('/message/message/getMessageList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 获取未读消息条数
const getMessageCount = async (obj) => {
  try {
    const res = await axios.post('/message/message/getMessageCount', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 设置部分已读
const setRead = async (obj) => {
  try {
    const res = await axios.post('/message/message/setOneRead', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 设置全部已读
const setAllRead = async (obj) => {
  try {
    const res = await axios.post('/message/message/setRead', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

const checkSSOLogin = async (obj) => {
  try {
    const res = await axios.post('/user/checkSsoLogin', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (msg === 'Undefined index: verify') {
      message.error('请先点击按钮进行验证');
      return false;
    }
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

export {
  getUserInfo,
  getMenuList,
  changePass,
  changeInfo,
  getMessageList,
  getMessageCount,
  setRead,
  setAllRead,
  loginout,
  checkSSOLogin,
};
