import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 广告列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加
const addAd = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 详情
const InfoAd = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 修改
const editAd = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除
const delAd = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 启用停用
const changeStatus = async (obj) => {
  try {
    const res = await axios.post('/ad/ad/changeStatus', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

export { getList, addAd, InfoAd, editAd, delAd, changeStatus };
