import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 角色列表
const getAllList = async (obj) => {
  try {
    const res = await axios.post('/user/role/getAllList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 角色列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/user/role/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 添加
const addRole = async (obj) => {
  try {
    const res = await axios.post('/user/role/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 详情
const infoRole = async (obj) => {
  try {
    const res = await axios.post('/user/role/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改
const editRole = async (obj) => {
  try {
    const res = await axios.post('/user/role/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
const delRole = async (obj) => {
  try {
    const res = await axios.post('/user/role/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
const changeStatus = async (obj) => {
  try {
    const res = await axios.post('/user/role/changeStatus', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 获取角色已选权限
const getPowerByRoleId = async (obj) => {
  try {
    const res = await axios.post('/user/role/getPowerByRoleId', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 设置角色权限
const setRolePower = async (obj) => {
  try {
    const res = await axios.post('/user/role/setRolePower', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 获取所有权限列表
const getAllrole = async (obj) => {
  try {
    const res = await axios.post('/system/power/getListAll', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export {
  getAllList,
  getList,
  addRole,
  infoRole,
  editRole,
  changeStatus,
  delRole,
  getPowerByRoleId,
  setRolePower,
  getAllrole,
};
