import React, { useEffect, useState } from 'react';
import {
  Table,
  Input,
  Button,
  Row,
  Col,
  Space,
  DatePicker,
  Pagination,
  Drawer,
  Form,
  Select,
} from 'antd';
const { RangePicker } = DatePicker;
import { useLocation } from 'react-router-dom';
import PaginationCom from '@/common/Pagination/index.jsx';
import { getIntegralRecordList } from '../list/request';
import TableCom from '@/common/TableCom/index';
const IntegralRecord = (props) => {
  const { id } = props;
  const [data, setData] = useState([]);
  const [page_size, setpage_size] = useState(2);
  const [page, setPage] = useState(1);
  const [total, setTotal] = useState(4);
  const [loading, setLoading] = useState(true);
  const [isEdit, setIsEdit] = useState(false);
  const [form] = Form.useForm();
  const init = async (obj = {}) => {
    setLoading(true);
    const { total, list } = await getIntegralRecordList({ id });
    setTotal(total);
    setData(list);
    setLoading(false);
  };
  const columns = [
    {
      title: '积分变更',
      key: 'score_change',
      dataIndex: 'options',
      align: 'center',
      render: (options, record) => {
        let operationText;
        switch (options) {
          case 1:
            operationText = `加`;
            break;
          case 2:
            operationText = `减`;
            break;
          default:
            operationText = '';
        }

        return (
          <div>
            {operationText}
            {record.numbers}
          </div>
        );
      },
    },

    {
      title: '最终积分',
      key: 'result',
      dataIndex: 'result',
      align: 'center',
    },
    {
      title: '备注',
      key: 'remarks',
      dataIndex: 'remarks',
      align: 'center',
    },
    {
      title: '创建时间',
      key: 'create_time',
      dataIndex: 'create_time',
      align: 'center',
    },
  ];
  return (
    <div>
      {TableCom({ columns, loading, data })}
      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
      />
    </div>
  );
};

export default IntegralRecord;
