import React, { useState, useEffect, useRef } from 'react';
import { Form, Input, Radio, Space, Button, Spin, DatePicker } from 'antd';
import { getSystem, systemEdit } from '../point-management/request';
const Personalized = () => {
  const [form] = Form.useForm();
  const flag = useRef(true);
  const [loading, setLoading] = useState(false);
  // 获取信息
  const getInfo = async () => {
    console.log(222);
    setLoading(true);
    const data = await getSystem();
    form.setFieldsValue(data);
    setLoading(false);
  };
  // 设置个性化信息
  const handleSystemEdit = async (obj) => {
    const bool = await systemEdit(obj);
    bool && getInfo();
  };
  useEffect(() => {
    getInfo();
  }, []);
  return (
    <div style={{ padding: 20 }}>
      <Spin spinning={loading}>
        <Form form={form} onFinish={handleSystemEdit}>
          <Form.Item
            label='老师分成百分比(%)'
            name='teacher_divide'
            rules={[{ required: true, message: '老师分成百分比不能为空' }]}
            extra='老师佣金计算(预计总收入),编写书籍售卖总金额+分成比例'
          >
            <Input
              autoComplete='off'
              style={{ width: 260 }}
              placeholder='请输入老师分成百分比'
            ></Input>
          </Form.Item>
          <Form.Item
            label='用户等级有效期(月)'
            name='user_grade_validity'
            rules={[{ required: true, message: '请输入用户等级有效期(月)' }]}
            extra='用于计算用户等级,根据当前时间之前有效期内的消费金额总和来计算'
          >
            <Input
              autoComplete='off'
              style={{ width: 260 }}
              placeholder='请输入用户等级有效期'
            ></Input>
          </Form.Item>
          <Form.Item
            name='comments_need_approval'
            label='评论是否需要审核'
            rules={[{ required: true, message: '请选择评论是否需要审核' }]}
          >
            <Radio.Group>
              <Radio value={'1'}>是</Radio>
              <Radio value={'0'}>否</Radio>
            </Radio.Group>
          </Form.Item>
          <Form.Item wrapperCol={{ offset: 2 }}>
            <Space>
              <Button
                type='primary'
                ghost
                onClick={() => {
                  form.setFieldsValue({
                    teacher_divide: '',
                    user_grade_validity: '',
                    comments_need_approval: '',
                  });
                }}
              >
                重置
              </Button>
              <Button type='primary' loading={loading} htmlType='submit'>
                确定
              </Button>
            </Space>
          </Form.Item>
        </Form>
      </Spin>
    </div>
  );
};

export default Personalized;
