import axios from '@/utils/request';
import { message } from 'antd';
import api from './api';
import { get } from 'lodash-es';
import qs from 'qs';

// 获取图形验证码
const getCaptcha = async (obj) => {
  try {
    const res = await axios.get(api.getCaptcha, obj);
    const status = get(res, 'status', 0);
    const data = get(res, 'data', '');
    if (status === 200) {
      return data;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

// 发送短信验证码
const sendSMS = async (data) => {
  try {
    const res = await axios.post(api.sendSMS, data);
    const code = get(res, 'data.code', 0);
    const msg = get(res, 'data.message', '发送失败');
    if (code === 200) {
      message.success('验证码发送成功！');
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

// 用户名登录
const userNameLogin = async (obj) => {
  try {
    const res = await axios.post(api.loginByUsername, obj);
    const code = get(res, 'data.code', 0);
    const msg = get(res, 'data.message', '登录失败');
    const data = get(res, 'data.data', '');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

// 手机号登录
const phoneLogin = async (obj) => {
  try {
    const res = await axios.post(api.loginByPhone, obj);
    const code = get(res, 'data.code', 0);
    const msg = get(res, 'data.message', '登录失败');
    const data = get(res, 'data.data', '');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

const checkSSOLogin = async (obj) => {
  try {
    const res = await axios.post(api.checkSSOLogin, qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (msg === 'Undefined index: verify') {
      message.error('请先点击按钮进行验证');
      return false;
    }
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

export { getCaptcha, sendSMS, userNameLogin, phoneLogin, checkSSOLogin };
