import { configureStore, combineReducers } from '@reduxjs/toolkit';
import { persistStore, persistReducer } from 'redux-persist';
import storage from 'redux-persist/lib/storage'; // defaults to localStorage for web
import * as reducers from './modules';

const persistConfig = {
  key: 'user',
  storage,
  whitelist: ['user'], // replace with the name of your reducer module
};

const reducer = combineReducers({
  ...reducers,
});

const persistedReducer = persistReducer(persistConfig, reducer);

const store = configureStore({
  reducer: persistedReducer,
  // 解决了序列化问题
  middleware: (getDefaultMiddleware) => getDefaultMiddleware({ serializableCheck: false }),
});

export default store;
export const persistor = persistStore(store);
