const fs = require('fs')
const path = require('path')
const axios = require('axios')

const domain = 'ezijing.com'

const outputPath = './https'

// 生成文件夹
function genOutputDir() {
  if (fs.existsSync(outputPath)) {
    console.log('The path exists.')
  } else {
    fs.mkdir(outputPath, { recursive: true }, err => {
      if (err) throw err
    })
  }
}

function downloadCertFile() {
  genOutputDir()
  axios
    .get(`https://ssl.godzyx.com/${domain}/${domain}.key?get=allow`, { responseType: 'stream' })
    .then(response => {
      response.data.pipe(fs.createWriteStream(path.join(__dirname, `${outputPath}/${domain}.key`)))
    })
    .catch(err => {
      console.log(err.message)
    })

  axios
    .get(`https://ssl.godzyx.com/${domain}/${domain}.pem?get=allow`, { responseType: 'stream' })
    .then(response => {
      response.data.pipe(fs.createWriteStream(path.join(__dirname, `${outputPath}/${domain}.pem`)))
    })
    .catch(err => {
      console.log(err.message)
    })
}
downloadCertFile()
