import httpRequest from '@/utils/axios'

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 图片上传
export function uploadFile(data) {
  return httpRequest.post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取表头
export function getTableColumns(params) {
  return httpRequest.get('/api/finance/v1/payments/title-list', { params })
}
// 更新表头
export function updateTableColumns(data) {
  return httpRequest.post('/api/finance/v1/payments/update-title', data)
}
// 获取历史发票信息
export function getRoles(params) {
  return httpRequest.get('/api/finance/user/get-info', { params })
}
// 下载发票列表
export function download(data) {
  return httpRequest.post('/api/finance/v1/invoices/download', data)
}
