import { getProjectList } from '@/api/base'

export function useProjectList(id?: string, projectId?: string) {
  const list = ref([])
  const members = ref([])
  const departmentList = ref([])
  getProjectList({ organization_id: id, project_id: projectId, semester: 1 }).then((res: any) => {
    list.value = res.data.departments
    members.value = res.data.members
    departmentList.value = res.data.departments.reduce((a: any, b: any) => {
      if (b.organizations.length) {
        a.push(b.organizations)
      }
      return a.flat(Infinity)
    }, [])
  })
  return { list, members, departmentList }
}
