import httpRequest from '@/utils/axios'

// 获取视频列表
export function getVideoList(params: {
  course_id: string
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-video', { params })
}

// 获取视频详情
export function getVideoDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/video/view', { params })
}

// 获取课程列表
export function getCourseList(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/list', { params })
}
// 获取课件列表
export function getCourseListSearch(params: {
  tab: string
  name?: string
  authorized?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/resource/v1/course/course/search-courseware', { params })
}

// 获取课程统计
export function getCourseStatistics() {
  return httpRequest.get('/api/resource/v1/course/course/statistics')
}

// 获取章节
export function getCharacter(params: { course_id: string; type: string }) {
  return httpRequest.get('/api/resource/v1/course/course/chapters', { params })
}

// 获取课程详情
export function getViewCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/view', { params })
}

// 获取教案详情
export function getLessonDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/view', { params })
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-belong', data)
}

// 课程授权
export function courseAuthorization(data: { id: string; organ_ids: string }) {
  return httpRequest.post('/api/resource/v1/course/course/authorization', data)
}

// 复制课程
export function courseCopy(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/copy', data)
}
// 控制资料能否下载
export function setDownload(data: { course_id: string; information_id: string; can_download: string }) {
  return httpRequest.post('/api/resource/v1/course/course/set-course-information-can-download  ', data)
}


// 获取知识图谱
export function getTagList(params: { type: string; parent_id: string; chapter_id?: string }) {
  return httpRequest.get('/api/resource/v1/course/course/tag-list', { params })
}

// 新增知识图谱
export function addTag(data: { name: string; course_id: string; status: string; parent_id?: string }) {
  return httpRequest.post('/api/resource/v1/course/course/tag-add', data)
}

// 更新知识图谱
export function updateTag(data: { id: string; name: string; course_id: string; status: string; }) {
  return httpRequest.post('/api/resource/v1/course/course/tag-update', data)
}

// 删除知识图谱
export function deleteTag(data: { id: string; course_id: string }) {
  return httpRequest.post('/api/resource/v1/course/course/tag-delete', data)
}

// 查看关联的课程章节
export function viewTagCourse(params: { tag_id: string; course_id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/tag-course', { params })
}

// 查看关联的书籍章节
export function viewTagBook(params: { tag_id: string; course_id: string }) {
  return httpRequest.get('/api/resource/v1/course/course/tag-book', { params })
}

// 导入
export function importTag(data: { course_id: string; file: any }) {
  return httpRequest.post('/api/resource/v1/course/course/tag-import', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}