import httpRequest from '@/utils/axios'

// 获取课件列表
export function getCourseList(params: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/resource/courseware/list', { params })
}

// 创建
export function createCourse(data: {
  name: string
  source: string
  classification: string
  knowledge_points?: string
  url: string
  type: string
  size: string
}) {
  return httpRequest.post('/api/resource/v1/resource/courseware/create', data)
}

// 更新课件
export function updateCourse(data: {
  id: string,
  name: string
  source: string
  classification: string
  knowledge_points?: string
  url: string
  type: string
  size: string
}) {
  return httpRequest.post('/api/resource/v1/resource/courseware/update', data)
}
// 获取课件详情
export function getCourseDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/courseware/view', { params })
}

// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/courseware/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/courseware/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/courseware/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/courseware/set-belong', data)
}
