import httpRequest from '@/utils/axios'

// 获取搜索条件
export function getConditionList(params?: {
  type: string
  organ_id?: string
  semester_id: string
  course_id?: string
}) {
  return httpRequest.get('/api/resource/v1/teaching/discussion/search-list', { params })
}
// 搜索帖子列表
export function getPostsList(params?: {
  organ_id?: string
  semester_id?: string
  class_id?: string
  course_id?: string
  chapter_id?: string
  type?: string
  is_top?: string
  title?: string
  name?: string
  page?: string
  ['per-page']: string
}) {
  return httpRequest.get('/api/resource/v1/teaching/discussion/list', { params })
}
// 搜索帖子列表
export function createPosts(data?: {
  organ_id: string
  semester_id: string
  class_id: string
  course_id: string
  chapter_id: string
  type: string
  is_top: string
  title: string
  name: string
  content: string
  files: string
}) {
  return httpRequest.post('/api/resource/v1/teaching/discussion/create', data)
}
// 删除帖子
export function delPosts(data?: { type: string; id: string }) {
  return httpRequest.post('/api/resource/v1/teaching/discussion/delete', data)
}
// 置顶帖子
export function setTopPosts(data?: { discussion_id: string }) {
  return httpRequest.post('/api/resource/v1/teaching/discussion/set-top', data)
}
// 帖子楼层的列表（一级评论列表）
export function getPostFirst(params?: { discussion_id: string; page?: string; ['per-page']: string }) {
  return httpRequest.get('/api/resource/v1/teaching/discussion/replies', { params })
}
// 回复帖子
export function replyPosts(data?: { discussion_id: string; reply_type: string; content: string; reply_id: string }) {
  return httpRequest.post('/api/resource/v1/teaching/discussion/reply', data)
}
// 帖子楼层回复的列表（二级评论列表）
export function getReplyPostItem(params?: { reply_id: string; page?: string; ['per-page']: string }) {
  return httpRequest.get('/api/resource/v1/teaching/discussion/comments', { params })
}
