import httpRequest from '@/utils/axios'

// 获取教案列表
export function getLessonList(params?: {
  tab: string
  status?: string
  authorized?: string
  classification?: string
  page?: number
  ['per-page']?: number
}) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/list', { params })
}

// 创建教案
export function createLessonPlan(data: {
  name: string
  source: string
  classification: string
  knowledge_points?: string
  url: string
  type: string
  size: string
}) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/create', data)
}

// 更新教案
export function updateLessonPlan(data: {
  id: string,
  name: string
  source: string
  classification: string
  knowledge_points?: string
  url: string
  type: string
  size: string
}) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/update', data)
}

// 获取教案详情
export function getLessonDetails(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/resource/lesson-plan/view', { params })
}
// 部门共享
export function setDepartment(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/set-department', data)
}

// 平台共享
export function setPlatform(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/set-platform', data)
}

// 上下线
export function setStatus(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/set-status', data)
}

// 更改负责人
export function setBelong(data: { id: string; belong_operator: string }) {
  return httpRequest.post('/api/resource/v1/resource/lesson-plan/set-belong', data)
}