import httpRequest from '@/utils/axios'

// 获取学生列表
export function getStudentList(params?: { name?: string; organ_id?: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/student/list', { params })
}
// 导入学生
export function importStudent(data: { url: string; name: string; size: number }) {
  return httpRequest.post('/api/resource/v1/learning/student/import', data)
}

// 批量修改学生
export function batchUpdateStudent(data: { url: string; name: string; size: number }) {
  return httpRequest.post('/api/resource/v1/learning/student/batch-update', data)
}

// 导出学生
export function exportStudent(params: { name: string; organ_id: string }) {
  return httpRequest.get('/api/resource/v1/learning/student/download', { params, responseType: 'blob' })
}

// 添加学生
export function addStudent(data?: {
  name: string
  id_type: string
  gender: string
  mobile: string
  id_number: string
  organ_id: string
  sno_number: string
  class_id?: string
  specialty_id?: string
}) {
  return httpRequest.post('/api/resource/v1/learning/student/create', data)
}
// 更新学生
export function updateStudent(data?: {
  id: string
  name: string
  id_type: string
  gender: string
  mobile: string
  id_number: string
  organ_id: string
  sno_number: string
  class_id?: string
  specialty_id?: string
}) {
  return httpRequest.post('/api/resource/v1/learning/student/update', data)
}

// 获取学生详情
export function getStuDetail(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/learning/student/view', { params })
}
// 班级搜索
export function searchClass(params?: { specialty_id: string; organ_id: string; page?: string; 'per-page'?: string }) {
  return httpRequest.get('/api/resource/v1/learning/student/search-class', { params })
}
// 获取专业列表
export function getProList(params?: { name?: string; page?: string; 'per-page'?: string; sort?: string }) {
  return httpRequest.get('/api/resource/v1/backend/specialty/list', { params })
}
// 获取班级列表
export function getClassList(params?: {
  specialty_id: string
  organ_id: string
  page?: string
  'per-page'?: string
  sort?: string
}) {
  return httpRequest.get('/api/resource/v1/learning/class/list', { params })
}

// 学生导入进度查询
export function getStudentProgress(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/learning/student/progress', { params })
}
