const fs = require('fs')

const conf = require('../config')
const com = require('@god/node-com')

const Proxy = com.Proxy

const ckeditorUpload = (req, res) => {
  /* 文件上传 ckeditor4.5以上返回格式 */
  function sendHtml (url, msg) {
    res.json({
      'uploaded': url ? 1 : 0,
      'fileName': 'image',
      'url': url,
      'error': {
        'message': msg
      }
    })
  }
  if (req.files.length) {
    if (!req.files[0].mimetype.startsWith('image')) { sendHtml('', '文件类型错误，请上传图片'); return }
    if (req.files[0].size > 10 * 1024 * 1024) { sendHtml('', '图片大小超限'); return }
    req.files[0].fieldname = 'file'

    Proxy.reqHttps({
      hostname: req.headers.reqhost, // 直接传 host，会被 kong的nginx接管，不能再调用，所以改为自定义host
      path: '/api/lms/util/upload-file',
      method: 'POST',
      data: req.body || {},
      query: req.query || {},
      files: req.files,
      headers: {
        'tenant': req.headers.tenant,
        'Cookie': req.headers.cookie || '',
        'User-Agent': req.headers['user-agent'],
        'Content-Type': 'multipart/form-data'
      }
    }, function (str, obj) {
      try {
        const _json = JSON.parse(str)
        if (_json.success) {
          sendHtml(_json.url, '')
        } else {
          sendHtml('', '上传错误，请重试')
        }
      } catch (e) {
        sendHtml('', '上传错误，请重试1')
      }
    })
  }
}

module.exports = {
  ckeditorUpload: ckeditorUpload
}
