const fs = require('fs')
// 自带模块 crypto
const crypto = require('crypto')
const path = require('path')
const com = require('@god/node-com')

const Proxy = com.Proxy
const md5 = com.Tool.md5
// [开方平台API](https://open.esign.cn/doc/detail?id=opendoc%2Fpaas_api%2Fvwtg6m&namespace=opendoc%2Fpaas_api)

const appPro1 = {
  AppId: '5111635045',
  AppSecret: '0f35445117f738c9292c52ad8af94064'
}
// 数据文件必须存 固定地点
const appPro2 = {
  AppId: '5111635068',
  AppSecret: '596c54b16ea817be0a1952d75e600435',
  fileId: 'a830a10b55ff46bebc0edc4cec15ebc0',
  // accountId: '1ca237fc1e6a466e878bc2274a9c1cec',
  // flowId: '9926fcd1956d41ab8e081c4480562f53'
}

const appTest = {
  AppId: '7438837529',
  AppSecret: '1994cd14f5f3eb3c8d23b23c4250919e',
  fileId: 'a830a10b55ff46bebc0edc4cec15ebc0',
  // accountId: '1ca237fc1e6a466e878bc2274a9c1cec',
  // flowId: '9926fcd1956d41ab8e081c4480562f53'
}

let _accessToken = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJnSWQiOiIzZWVkMDZkODE1MmQ0YzNlOGMwOGM2ZTQzNjA5ODViZCIsImFwcElkIjoiNTExMTYzNTA2OCIsIm9JZCI6IjhiYTNkMDY0ZDZjYTQ0MThhM2Q0YzNkNTI4MDVlOWJiIiwidGltZXN0YW1wIjoxNjA5NDMxOTg5NTQ4fQ.3F4izbojHlWj80zA4mUcgBZTWJn9IDzQsd-tHQw7cr8'

let _info = {
  domain_test: 'smlopenapi.esign.cn',
  domain_pro: 'openapi.esign.cn'
}



// const _app = appPro2
// const _domain = _info.domain_pro
const _app = appTest
const _domain = _info.domain_test


const _getAccessToken = (req, res) => {
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/oauth2/access_token',
    method: 'GET',
    data: {},
    query: {
      appId: _app.AppId,
      secret: _app.AppSecret,
      grantType: 'client_credentials'
    },
    headers: {
      'Host': _domain
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: '_getAccessToken 接口 调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }
    if (_json.code !== 0) {
      res.status(200).json(_json)
      return
    }
    _accessToken = _json.data.token
    res.status(200).json(_json)
  })
}

// 需要传一个 file - 暂时只支持单文件
const _getUploadUrl = (req, res) => {

  // 暂时先指定 originalname，中文本地服务存在问题
  req.files[0].originalname = req.body.name || req.files[0].originalname

  // 计算 content-md5
  let buffer = fs.readFileSync(req.files[0].path)
  let str_md5 = crypto.createHash('md5').update(buffer).digest('hex')
  console.log(str_md5)
  let str_base64_md5 = Buffer.from(crypto.createHash('md5').update(buffer).digest()).toString('base64')
  console.log(str_base64_md5)

  // 重命名
  fs.renameSync(req.files[0].path, req.files[0].destination + req.files[0].originalname)
  req.files[0].path = req.files[0].destination + req.files[0].originalname

  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/files/getUploadUrl',
    method: 'POST',
    data: {
      accountId: '',
      contentMd5: str_base64_md5,
      contentType: 'application/octet-stream',
      convert2Pdf: /pdf/gi.test(req.files[0].originalname),
      fileName: req.files[0].originalname, // req.files[0].originalname  暂时存在一个问题，1.本地服务中文乱码
      fileSize: req.files[0].size
    },
    query: {},
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: '_getUploadUrl 接口 第一步调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }
    if (_json.code !== 0) {
      res.status(200).json(_json)
      return
    }

    // 上一个接口调用没问题，再调用下一个接口
    let fileId = _json.data.fileId
    console.log(fileId)
    _uploadFileFromOctetStream(_json.data.uploadUrl, str_base64_md5, req.files[0].path, (_json) => {
      _json.fileId = fileId
      _app.fileId = fileId
      res.status(200).json(_json)
    })
  })
}

// 通过 application/octet-stream 方式 上传 文件
const _uploadFileFromOctetStream = (uploadUrl, str_base64_md5, filePath, callback) => {
  let buffer = fs.readFileSync(filePath)
  console.log(uploadUrl)
  Proxy.reqHttps({
    hostname: uploadUrl.replace(/http(s|):\/\//gi, '').replace(/\/.*$/gi, ''),
    path: uploadUrl.replace(/http(s|):\/\/[^\/]*?\//gi, '/'),
    method: 'PUT',
    data: Buffer.from(buffer, 'binary'),
    query: {},
    headers: {
      'content-md5': str_base64_md5,
      'content-type': 'application/octet-stream',
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: '_getUploadUrl 接口 第二步 _uploadFileFromOctetStream 调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      _json = jsonErr
    }
    callback(_json)
  })
}

// 根据 fileId 查询文件上传状态
const _getInfoToUploadFile = (req, res) => {
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/files/' + req.body.fileId,
    method: 'GET',
    data: {},
    query: {},
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    console.log(str)
    // callback(str)
    res.status(200).json(JSON.parse(str))
  })
}

// 先调用创建用户 再一建发起签署，返回url
const getOneStepUrl = (req, res) => {
  _token(req, res, () => {
    _createUser(req, res, (accountId) => {
      req.accountId = accountId
      _signFlowId(req, res, (flowId) => {
        req.flowId = flowId
        _getUrl(req, res, (_json) => {
          res.status(200).json(_json)
        })
      })
    })
  })
}
const _token = (req, res, callback) => {
  // 获取token
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/oauth2/access_token',
    method: 'GET',
    data: {},
    query: {
      appId: _app.AppId,
      secret: _app.AppSecret,
      grantType: 'client_credentials'
    },
    headers: {
      'Host': _domain
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: 'getOneStepUrl 接口 第一步 /v1/oauth2/access_token调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }
    if (_json.code !== 0) {
      res.status(200).json(_json)
      return
    }
    _accessToken = _json.data.token

    callback && callback()
  })
}
const _createUser = (req, res, callback) => {
  // 创建用户
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/accounts/createByThirdPartyUserId',
    method: 'POST',
    data: {
      "email": req.body.email || "",
      "idNumber": "",
      "idType": "",
      "mobile": req.body.mobile || "",
      "name": req.body.name || "张彦新",
      "thirdPartyUserId": req.body.uuid || "17601621100"
    },
    query: {},
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: 'getOneStepUrl 接口 第二步 /v1/accounts/createByThirdPartyUserId调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }
    // 账号已存在 - 可以继续签署
    if (_json.code !== 0 && _json.code !== 53000000) {
      res.status(200).json(_json)
      return
    }

    // accountId 传入，防止高并发时，出现意外
    callback && callback(_json.data.accountId)
  })
}
const _signFlowId = (req, res, callback) => {
  // 一建发起签署
  Proxy.reqHttps({
    hostname: _domain,
    path: '/api/v2/signflows/createFlowOneStep',
    method: 'POST',
    data: {
      "attachments": [],
      "copiers": [],
      "docs":[{
        "fileId": _app.fileId,
        "fileName": "",
        "filePassword": ""
      }],
      "flowInfo": {
        "autoArchive": true,
        "autoInitiate": true,
        "businessScene": "Test 一键发起部署",
        "flowConfigInfo": {
          "noticeDeveloperUrl": "",
          "noticeType": "",
          "redirectUrl": "",
          "signPlatform": ""
        },
        "initiatorAccountId": "",
        "initiatorAuthorizedAccountId": "",
        "remark": ""
      },
      "signers": [{
        "platformSign": false,
        "signerAccount": {
          "authorizedAccountId": "",
          "signerAccountId": req.accountId
        },
        "signfields": [{
          "autoExecute": false,
          "fileId": _app.fileId,
          "signType": 0,
          "posBean": {
            "posPage": ""
          },
          "sealId": "",
          "sealType": "0, 1",
          "signDateBean": {
            "format": ""
          }
        }],
        "thirdOrderNo": ""
      }]
    },
    query: {},
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: 'getOneStepUrl 接口 第三步 /api/v2/signflows/createFlowOneStep调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }

    if (_json.code !== 0) {
      res.status(200).json(_json)
      return
    }

    // 每次生成的flowId不一致，防止高并发时出现意外
    callback && callback(_json.data.flowId)
  })
}
const _getUrl = (req, res, callback) => {
  // 获取url
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/signflows/' + req.flowId + '/executeUrl',
    method: 'GET',
    data: {},
    query: {
      flowId: req.flowId,
      accountId: req.accountId
    },
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    let jsonErr = { code: 500, message: 'getOneStepUrl 接口 第四步 /v1/signflows/{flowId}/executeUrl调用失败' }
    let _json = {}
    try {
      _json = JSON.parse(str)
    } catch (e) {
      console.log(e)
      res.status(200).json(jsonErr)
      return
    }

    if (_json.code !== 0) {
      res.status(200).json(_json)
      return
    }
    console.log(_json)
    _json.data.flowId = req.flowId
    _json.data.accountId = req.accountId
    _json.data.fileId = _app.fileId
    callback && callback(_json)
  })
}

// 获取签署后的文件
const getAfterSignFile = (req, res) => {
  Proxy.reqHttps({
    hostname: _domain,
    path: '/v1/signflows/' + req.body.flowId + '/documents',
    method: 'GET',
    data: {},
    query: {},
    headers: {
      'Host': _domain,
      'Content-Type': 'application/json; charset=UTF-8',
      'X-Tsign-Open-Token': _accessToken,
      'X-Tsign-Open-App-Id': _app.AppId
    }
  }, function (str, obj) {
    console.log(str)
    // callback(str)
    res.status(200).json(JSON.parse(str))
  })
}


module.exports = {
  _getAccessToken: _getAccessToken,
  _getUploadUrl: _getUploadUrl,
  _getInfoToUploadFile: _getInfoToUploadFile,
  getOneStepUrl: getOneStepUrl,
  getAfterSignFile: getAfterSignFile
}
