const fs = require('fs')
const path = require('path')
const com = require('@god/node-com')

const _mkdir = com.Tool.Directory.mkdir

const getTable = (req, res) => {
  let path1 = path.resolve(process.cwd(), '../node-server-data/cloud-class.json')
  if (!fs.existsSync(path1)) {
    _mkdir(path1.replace(/\/[^\/]*?$/gi, ''), () => {
      fs.writeFileSync(path1, JSON.stringify({}), 'utf8')
    })
    res.status(200).json({ 'msg': '文件不存在，创建文件' })
    return
  }
  let _json = JSON.parse(fs.readFileSync(path1).toString() || '{}')
  res.status(200).json(_json)
}

const setTable = (req, res) => {
  let path1 = path.resolve(process.cwd(), '../node-server-data/cloud-class.json')
  if (!fs.existsSync(path1)) {
    _mkdir(path1)
    res.status(200).json({ 'msg': '文件不存在，创建文件' })
    return
  }
  let _json = JSON.parse(fs.readFileSync(path1).toString() || '{}')
  if (req.body.chapterId) {
    _json[req.body.chapterId] = req.body.url
  } else {
    for (let k in req.body) {
      _json[k] = req.body[k]
    }
  }
  fs.writeFileSync(path1, JSON.stringify(_json), 'utf8')
  res.status(200).json(_json)
}

module.exports = {
  getTable: getTable,
  setTable: setTable
}
