const fs = require('fs')
const path = require('path')
const com = require('@god/node-com')

const _mkdir = com.Tool.Directory.mkdir

const get = (req, res) => {
  let path1 = path.resolve(process.cwd(), '../node-server-data/wxchart-success.json')
  if (!fs.existsSync(path1)) {
    _mkdir(path1.replace(/\/[^\/]*?$/gi, ''), () => {
      fs.writeFileSync(path1, JSON.stringify({}), 'utf8')
    })
    res.status(200).json({ 'msg': '文件不存在，创建文件' })
    return
  }
  let _json = JSON.parse(fs.readFileSync(path1).toString() || '{}')
  let keyStr = req.baseUrl.replace(/\/get\/wx-chart\//gi, '')
  /* 获取对应值 */
  res.status(200).json({ code: _json[keyStr] !== undefined ? _json[keyStr] : -1 })
}

const set = (req, res) => {
  let path1 = path.resolve(process.cwd(), '../node-server-data/wxchart-success.json')
  if (!fs.existsSync(path1)) {
    _mkdir(path1.replace(/\/[^\/]*?$/gi, ''))
    res.status(200).json({ 'msg': '文件不存在，创建文件' })
    return
  }
  let _json = JSON.parse(fs.readFileSync(path1).toString() || '{}')
  let keyStr = req.baseUrl.replace(/\/set\/wx-chart\//gi, '')
  _json[keyStr] = parseInt(req.query.val || 0)
  /* 设置对应值 */
  fs.writeFileSync(path1, JSON.stringify(_json), 'utf8')
  res.status(200).json(_json)
}

module.exports = {
  get: get,
  set: set
}
