const Router = require('express').Router
const router = Router()

const bodyParser = require('body-parser')
const multer = require('multer')
const upload = multer({ dest: 'upload_tmp/' })

const _test = require('../controller/TestMonitor')
const _wx = require('../controller/WxMonitor')
const _mfm = require('../controller/MixedFlowMonitor')
const _rtmp = require('../controller/RTMPMonitor')
const _sccm = require('../controller/setCloudClassMonitor')
const _nts = require('../controller/NextToSend')
const _pr = require('../controller/ProxyRequest')
const _wxcsm = require('../controller/wxChartSuccessMonitor')
const _cm = require('../controller/CkeditorMonitor')
const _es = require('../controller/ESignMonitor')

router.use(bodyParser.json({ limit: '60mb' }))
router.use(bodyParser.urlencoded({ extended: true, limit: '60mb' }))
router.use(bodyParser.text({ limit: '60mb' }))

router.use((req, res, next) => {
  /* 设置允许哪些外域访问此服务器。如果你要发送cookies，不要将其赋值为'*' */
  res.header('Access-Control-Allow-Origin', req.headers.origin || '*')
  /* 设置允许发送cookies。可选值：true,如果不允许就省略此字段 */
  res.header('Access-Control-Allow-Credentials', 'true')
  if (req.method === 'OPTIONS') {
    /* 设置允许那些方法访问此服务器 */
    res.header('Access-Control-Allow-Methods', 'PUT, GET, POST, DELETE, OPTIONS')
    /* 设置允许那些头文件访问此服务器，数组中可以设置一些自定义首部 */
    let strArr = ['token', 'tenant', 'cur-json', 'version']
    for (let k in req.headers) { strArr.push(k) }
    res.header('Access-Control-Allow-Headers', strArr.join(', '))
    /* 设置单个接口 OPTIONS 的最大有效时长 */
    res.header('Access-Control-Max-Age', 600)
    /* 以下设置OPTIONS返回并给空内容 */
    res.header('Content-Type', 'text/plain charset=UTF-8')
    res.header('Content-Length', 0)
    res.status(204).end()
    return
  }
  next()
})

router.post('/api/test', upload.any(), _test.isRun)
router.get('/api/test', _test.isRun)
// 重新获取token 在分享
router.post('/share/getsignature', _wx.wxGetsignature)
// 微信分享
router.post('/share/token', _wx.wxShare)
// 获取用户信息
router.post('/getInfo', _wx.wxGetInfo)
// 云端混流
router.post('/set/mixed-flow', _mfm.getFlow)
// 推流回调
router.post('/get/rtmp/callback', _rtmp.callback)
// 获取云课堂对照表
router.get('/get/cloud-class', _sccm.getTable)
// 设置云课堂对照表 - 添加key-value
router.post('/set/cloud-class', _sccm.setTable)
// 学习系统获取 - 视频课程列表 - 接口转发
router.get('/abc/test/cba/*', _nts.getData)
// 接口转发 - 解决跨域问题
router.use('/v1/pay/wechat/*', _pr.use)
// 支持微信过审 - 接口
router.use('/get/wx-chart/*', _wxcsm.get)
router.use('/set/wx-chart/*', _wxcsm.set)
// 支持 ckeditor 图片上传
router.use('/form/ckeditor-upload*', upload.any(), _cm.ckeditorUpload)
// 对接 e签宝 传入 姓名+手机号 返回 签署url
router.use('/get/sign/access/token', upload.any(), _es._getAccessToken)
router.use('/get/sign/upload/url', upload.any(), _es._getUploadUrl)
router.use('/get/sign/info/upload/file', upload.any(), _es._getInfoToUploadFile)
router.use('/get/sign/url', upload.any(), _es.getOneStepUrl)
router.use('/get/sign/download/url', upload.any(), _es.getAfterSignFile)

router.use('/api/*', upload.any(), (req, res) => { res.send('暂无该接口') })
router.use('*', upload.any(), (req, res) => { res.send('接口未定义') })

module.exports = router
