# ezijing-node-server

Modern Node.js API server for WeChat services and log collection.

## Quick Start

```bash
# Install dependencies
npm install

# Start MongoDB (required)
mongod --dbpath /path/to/data

# Development (with hot reload)
npm run dev

# Production
npm start
```

## Project Structure

```
src/
├── index.js          # Entry point
├── app.js            # Express app
├── config.js         # Configuration
├── lib/              # Shared utilities
│   ├── logger.js     # Pino logger
│   ├── db.js         # MongoDB connection
│   └── file.js       # File utilities
├── middleware/       # Global middleware
└── modules/          # Feature modules
    ├── wechat/       # WeChat SDK
    ├── wx-chart/     # WeChat chart data
    └── logs/         # Log collection
```

## API Endpoints

### System

| Method | Path | Description |
|--------|------|-------------|
| GET | `/health` | Health check |

### WeChat

| Method | Path | Description |
|--------|------|-------------|
| POST | `/share/getsignature` | Get WeChat JS-SDK signature |
| POST | `/share/token` | Get share token |
| POST | `/getInfo` | Get WeChat user info |

### Chart Data

| Method | Path | Description |
|--------|------|-------------|
| GET | `/get/wx-chart/:key` | Get chart value |
| GET | `/set/wx-chart/:key` | Set chart value |

### Logs

| Method | Path | Description |
|--------|------|-------------|
| POST | `/logs` | Create single log |
| POST | `/logs/batch` | Create batch logs |
| GET | `/logs` | Query logs |
| GET | `/logs/stats` | Get log statistics |

#### Log Request Body

```json
{
  "level": "info",
  "message": "User login",
  "source": "web-app",
  "userId": "user123",
  "metadata": { "action": "login" }
}
```

#### Query Parameters

- `level` - Log level (debug, info, warn, error, fatal)
- `source` - Log source
- `userId` - User ID
- `startTime` - Start time (ISO 8601)
- `endTime` - End time (ISO 8601)
- `keyword` - Search keyword
- `page` - Page number (default: 1)
- `limit` - Page size (default: 50)

## Environment Variables

```env
NODE_ENV=development
SERVER_PORT=4101
DATA_DIR=../node-server-data

# MongoDB
MONGODB_URI=mongodb://localhost:27017/ezijing-logs

# WeChat config (numbered format)
WX_APPID_1=your_appid
WX_SECRET_1=your_secret
```

## Scripts

- `npm run dev` - Development with hot reload
- `npm start` - Production
- `npm run lint` - ESLint check
- `npm run lint:fix` - ESLint fix
- `npm run deploy` - Deploy to production
