import app from './app.js'
import config from './config.js'
import logger from './lib/logger.js'
import { connectDB, disconnectDB } from './lib/db.js'

const start = async () => {
  try {
    await connectDB()

    const server = app.listen(config.port, () => {
      logger.info({ port: config.port, env: config.env }, 'Server started 🚀')
    })

    // Graceful shutdown
    const shutdown = async (signal) => {
      logger.info(`${signal} received, shutting down...`)
      server.close(async () => {
        await disconnectDB()
        logger.info('Server closed')
        process.exit(0)
      })
    }

    process.on('SIGTERM', () => shutdown('SIGTERM'))
    process.on('SIGINT', () => shutdown('SIGINT'))
  } catch (error) {
    logger.error({ err: error }, 'Failed to start server')
    process.exit(1)
  }
}

process.on('unhandledRejection', (err) => logger.error({ err }, 'Unhandled Rejection'))
process.on('uncaughtException', (err) => {
  logger.error({ err }, 'Uncaught Exception')
  process.exit(1)
})

start()
