import logger from '../lib/logger.js'
import { error } from '../lib/response.js'

export const notFound = (req, res) => {
  error(res, '接口未定义', 404, { path: req.path, method: req.method })
}

export const errorHandler = (err, req, res, _next) => {
  const statusCode = err.statusCode || err.status || 500
  const message = process.env.NODE_ENV === 'production' && statusCode === 500 ? 'Internal Server Error' : err.message

  logger.error({ err, url: req.url, method: req.method }, 'Request error')
  error(res, message, statusCode)
}
