import path from 'path'
import config from '../../config.js'
import { readJson, writeJson } from '../../lib/file.js'

const DATA_FILE = path.join(config.dataDir, 'wxchart-success.json')

export const getValue = async (key) => {
  const data = await readJson(DATA_FILE, {})
  return data[key] !== undefined ? data[key] : -1
}

export const setValue = async (key, value) => {
  const data = await readJson(DATA_FILE, {})
  data[key] = parseInt(value) || 0
  await writeJson(DATA_FILE, data)
  return data
}
