# ezijing-node-server

Modern Node.js API server for WeChat services.

## Quick Start

```bash
# Install dependencies
npm install

# Development (with hot reload)
npm run dev

# Production
npm start
```

## Project Structure

```
src/
├── index.js          # Entry point
├── app.js            # Express app
├── config.js         # Configuration
├── lib/              # Shared utilities
├── middleware/       # Global middleware
└── modules/          # Feature modules
    ├── wechat/       # WeChat SDK
    └── wx-chart/     # WeChat chart data
```

## API Endpoints

| Method | Path | Description |
|--------|------|-------------|
| GET | `/health` | Health check |
| POST | `/share/getsignature` | Get WeChat JS-SDK signature |
| POST | `/share/token` | Get share token |
| POST | `/getInfo` | Get WeChat user info |
| GET | `/get/wx-chart/:key` | Get chart value |
| GET | `/set/wx-chart/:key` | Set chart value |

## Environment Variables

```env
NODE_ENV=development
SERVER_PORT=4101
DATA_DIR=../node-server-data

# WeChat config (numbered format)
WX_APPID_1=your_appid
WX_SECRET_1=your_secret
```

## Scripts

- `npm run dev` - Development with hot reload
- `npm start` - Production
- `npm run lint` - ESLint check
- `npm run lint:fix` - ESLint fix
- `npm run deploy:test` - Deploy to test
- `npm run deploy:prod` - Deploy to production
