import globals from 'globals'

export default [
  {
    ignores: ['node_modules/', 'build/', 'dist/'],
  },
  {
    files: ['src/**/*.js'],
    languageOptions: {
      ecmaVersion: 2022,
      sourceType: 'module',
      globals: {
        ...globals.node,
      },
    },
    rules: {
      'no-unused-vars': ['error', { argsIgnorePattern: '^_' }],
      'no-console': 'off',
      'comma-dangle': ['error', 'always-multiline'],
      semi: ['error', 'never'],
      quotes: ['error', 'single'],
    },
  },
]
