import fs from 'fs/promises'
import { existsSync } from 'fs'
import path from 'path'
import logger from './logger.js'

export const ensureDir = async (filePath) => {
  const dir = path.dirname(filePath)
  await fs.mkdir(dir, { recursive: true })
}

export const readJson = async (filePath, defaultValue = {}) => {
  try {
    await ensureDir(filePath)
    if (!existsSync(filePath)) {
      await fs.writeFile(filePath, JSON.stringify(defaultValue, null, 2), 'utf8')
      return defaultValue
    }
    const content = await fs.readFile(filePath, 'utf8')
    return JSON.parse(content || '{}')
  } catch (error) {
    logger.error({ err: error, filePath }, 'Failed to read JSON file')
    throw error
  }
}

export const writeJson = async (filePath, data) => {
  try {
    await ensureDir(filePath)
    await fs.writeFile(filePath, JSON.stringify(data, null, 2), 'utf8')
    return data
  } catch (error) {
    logger.error({ err: error, filePath }, 'Failed to write JSON file')
    throw error
  }
}
