import logger from '../lib/logger.js'

export const notFound = (req, res) => {
  res.status(404).json({
    success: false,
    error: { message: '接口未定义', path: req.path, method: req.method },
  })
}

export const errorHandler = (err, req, res, _next) => {
  const statusCode = err.statusCode || err.status || 500
  logger.error({ err, url: req.url, method: req.method }, 'Request error')
  res.status(statusCode).json({
    success: false,
    error: {
      message: process.env.NODE_ENV === 'production' && statusCode === 500 ? 'Internal Server Error' : err.message,
    },
  })
}
