import * as wechatService from './wechat.service.js'
import logger from '../../lib/logger.js'

export const getSignature = async (req, res, next) => {
  try {
    const { appId, url } = req.body
    if (!appId) return res.status(400).json({ success: false, error: { message: 'appId is required' } })

    const ticket = await wechatService.getCachedTicket(appId)
    const encodedUrl = encodeURIComponent(url || req.headers.referer || '')
    const signature = wechatService.generateSignature(
      ticket.jsapi_ticket,
      ticket.noncestr,
      ticket.timestamp,
      encodedUrl
    )

    res.json({
      success: true,
      data: {
        url: encodedUrl,
        ticket: ticket.jsapi_ticket,
        token: signature,
        noncestr: ticket.noncestr,
        timestamp: ticket.timestamp,
      },
    })
  } catch (error) {
    logger.error({ err: error }, 'getSignature error')
    next(error)
  }
}

export const share = async (req, res, next) => {
  try {
    const { appId } = req.body
    if (!appId) return res.status(400).json({ success: false, error: { message: 'appId is required' } })

    const ticket = await wechatService.getCachedTicket(appId)
    const signature = wechatService.generateSignature(
      ticket.jsapi_ticket,
      ticket.noncestr,
      ticket.timestamp,
      req.headers.referer || ''
    )

    res.json({ success: true, data: { token: signature, noncestr: ticket.noncestr, timestamp: ticket.timestamp } })
  } catch (error) {
    logger.error({ err: error }, 'share error')
    next(error)
  }
}

export const getInfo = async (req, res, next) => {
  try {
    const { appId, code } = req.body
    if (!appId || !code)
      return res.status(400).json({ success: false, error: { message: 'appId and code are required' } })

    const userInfo = await wechatService.getUserInfo(appId, code)
    res.json({ success: true, data: userInfo })
  } catch (error) {
    logger.error({ err: error }, 'getInfo error')
    next(error)
  }
}
