import express from 'express'
import cors from 'cors'
import pinoHttp from 'pino-http'
import logger from './lib/logger.js'
import { notFound, errorHandler } from './middleware/error.js'
import wechatRoutes from './modules/wechat/wechat.routes.js'
import wxChartRoutes from './modules/wx-chart/wx-chart.routes.js'
import logsRoutes from './modules/logs/logs.routes.js'

const app = express()

// Trust proxy
app.set('trust proxy', true)

// Request logging
app.use(pinoHttp({ logger, autoLogging: process.env.NODE_ENV !== 'test' }))

// Middleware
app.use(cors({ credentials: true }))
app.use(express.json())
app.use(express.urlencoded({ extended: true }))

// Health check
app.get('/health', (req, res) => res.json({ status: 'ok', timestamp: Date.now() }))

// Modules
app.use(wechatRoutes)
app.use(wxChartRoutes)
app.use(logsRoutes)

// Error handling
app.use(notFound)
app.use(errorHandler)

export default app
