import 'dotenv/config'
import path from 'path'

const config = {
  env: process.env.NODE_ENV || 'development',
  port: parseInt(process.env.SERVER_PORT || '4101', 10) || 4101,
  dataDir: process.env.DATA_DIR || path.resolve(process.cwd(), '../node-server-data'),
  mongodb: {
    uri:
      process.env.MONGODB_URI ||
      'mongodb://log:log%402025@dds-2ze70e3ecb9601941614-pub.mongodb.rds.aliyuncs.com:3717/logs_data',
  },
  wechat: { apps: {} },
}

// Load WeChat config from env
let i = 1
while (process.env[`WX_APPID_${i}`] && process.env[`WX_SECRET_${i}`]) {
  config.wechat.apps[process.env[`WX_APPID_${i}`]] = process.env[`WX_SECRET_${i}`]
  i++
}

// Fallback
if (Object.keys(config.wechat.apps).length === 0) {
  config.wechat.apps = {
    wxd6109d07f6396e5c: 'd80a330735fc82f3fd6aba425481e8fd',
    wxe1849e28e176c67b: '90072420a6b6941b7b8af38afd019b9f',
    wxb9651d97aabb1a06: 'fc40521654d4a0157fb1bdf15dce760f',
    wx451c01d40d090d7a: 'c740445d23458904dd7cc8f2e1bc2601',
    wxb0280dd47666d2e9: 'f5f6e01dfa06da3a29b7fa710a287073',
    wxfe67f37095e08d2f: '689d4d5a5c3b1290e8ba7cc6fe872b28',
  }
}

export default config
