import mongoose from 'mongoose'
import config from '../config.js'
import logger from './logger.js'

let isConnected = false

export const connectDB = async () => {
  if (isConnected) return

  try {
    await mongoose.connect(config.mongodb.uri)
    isConnected = true
    logger.info({ uri: config.mongodb.uri.replace(/\/\/.*@/, '//*****@') }, 'MongoDB connected')
  } catch (error) {
    logger.error({ err: error }, 'MongoDB connection failed')
    throw error
  }
}

mongoose.connection.on('disconnected', () => {
  isConnected = false
  logger.warn('MongoDB disconnected')
})

mongoose.connection.on('error', (err) => {
  logger.error({ err }, 'MongoDB error')
})

export const disconnectDB = async () => {
  if (!isConnected) return
  await mongoose.disconnect()
  isConnected = false
  logger.info('MongoDB disconnected')
}

export default mongoose
