import * as wechatService from './wechat.service.js'
import logger from '../../lib/logger.js'

export const getSignature = async (req, res, next) => {
  try {
    const { appId, url } = req.body
    if (!appId) return res.status(400).json({ success: false, error: { message: 'appId is required' } })

    const ticket = await wechatService.getCachedTicket(appId)
    // 微信签名要求使用原始URL，去除hash部分
    const rawUrl = (url || req.headers.referer || '').split('#')[0]
    const signature = wechatService.generateSignature(ticket.jsapi_ticket, ticket.noncestr, ticket.timestamp, rawUrl)

    res.json({
      url: rawUrl,
      ticket: ticket.jsapi_ticket,
      token: signature,
      noncestr: ticket.noncestr,
      timestamp: ticket.timestamp,
    })
  } catch (error) {
    logger.error({ err: error }, 'getSignature error')
    next(error)
  }
}

export const share = async (req, res, next) => {
  try {
    const { appId } = req.body
    if (!appId) return res.status(400).json({ success: false, error: { message: 'appId is required' } })

    const ticket = await wechatService.getCachedTicket(appId)
    // 微信签名要求使用原始URL，去除hash部分
    const rawUrl = (req.headers.referer || '').split('#')[0]
    const signature = wechatService.generateSignature(ticket.jsapi_ticket, ticket.noncestr, ticket.timestamp, rawUrl)

    res.json({ token: signature, noncestr: ticket.noncestr, timestamp: ticket.timestamp })
  } catch (error) {
    logger.error({ err: error }, 'share error')
    next(error)
  }
}

export const getInfo = async (req, res, next) => {
  try {
    const { appId, code } = req.body
    if (!appId || !code)
      return res.status(400).json({ success: false, error: { message: 'appId and code are required' } })

    const userInfo = await wechatService.getUserInfo(appId, code)
    res.json(userInfo)
  } catch (error) {
    logger.error({ err: error }, 'getInfo error')
    next(error)
  }
}
