import * as service from './wx-chart.service.js'
import logger from '../../lib/logger.js'

export const get = async (req, res, next) => {
  try {
    const key = req.baseUrl.replace(/\/get\/wx-chart\//gi, '')
    if (!key) return res.status(400).json({ success: false, error: { message: 'Key is required' } })

    const value = await service.getValue(key)
    res.json({ success: true, data: { code: value } })
  } catch (error) {
    logger.error({ err: error }, 'wx-chart get error')
    next(error)
  }
}

export const set = async (req, res, next) => {
  try {
    const key = req.baseUrl.replace(/\/set\/wx-chart\//gi, '')
    if (!key) return res.status(400).json({ success: false, error: { message: 'Key is required' } })

    const data = await service.setValue(key, req.query.val || 0)
    res.json({ success: true, data })
  } catch (error) {
    logger.error({ err: error }, 'wx-chart set error')
    next(error)
  }
}
