import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import modules from './modules'

// 公共css
import './assets/css/base.css'
// Element-UI
import ElementUI from 'element-ui'
import './assets/theme/style.scss'
// 公共组件
import AppContainer from './components/base/AppContainer.vue'
import AppCard from './components/base/AppCard.vue'
import AppList from './components/base/AppList.vue'

import beforeEnter from './utils/beforeEnter'
import * as echarts from 'echarts'
Vue.prototype.$echarts = echarts

// 注册element-ui组件
Vue.use(ElementUI)

// 注册公共组件
Vue.component('AppContainer', AppContainer)
Vue.component('AppCard', AppCard)
Vue.component('AppList', AppList)

// 注册模块
modules({ router, store })

router.beforeEach(beforeEnter)

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
