import httpRequest from '@/utils/axios'
/**
 * 获取课程列表
 */
export function getCourseModule() {
  return httpRequest.get('/api/zy/v2/education/mokuai')
}

/**
 * 获取课程列表
 */
export function getCourseList() {
  return httpRequest.get('/api/lms-financial/v1/education/course-list')
}

/**
 * 获取课程详情
 * @param {string} courseId 课程ID
 */
export function getCourse(params) {
  return httpRequest.get('/api/lms-financial/v1/education/course-view', { params }).then(response => {
    // response.chapters = response.chapters.filter(item => {
    //   item.children = item.children.filter(child => child.type === 2)
    //   return item.children.length
    // })
    return response
  })
}

/**
 * 获取课程知识点
 * @param {string} courseId 课程ID
 */
export function getCourseTagList(courseId) {
  return httpRequest.get(`/api/zy/v2/education/tag/tree/${courseId}`)
}

/**
 * 知识点详情
 * @param {string} tagId 知识点ID
 */
export function getCourseTag(tagId) {
  return httpRequest.get(`/api/zy/v2/education/tag/${tagId}`)
}
