import httpRequest from '@/utils/axios'
/**
 * 获取考试列表
 */
export function getExamList() {
  return httpRequest.get('/api/lms-financial/v1/examination/list')
}

/**
 * 提交重修申请
 */
export function sbumitRetake(data) {
  return httpRequest.post('/api/lms-financial/v1/examination/retake', data)
}

/**
 * 获取考试列表
 */
export function getExamQuestion(params) {
  return httpRequest.get(
    '/api/lms-financial/v1/examination/paper',
    { params },
    { headers: { 'Content-Type': 'multipart/form-data' } }
  )
}

/**
 * 缓存模拟考试试题
 */
export function setCache(params) {
  return httpRequest.post('/api/lms-financial/v1/examination/submit-paper', params)
}
