import axios from 'axios'
import qs from 'qs'
import { Message } from 'element-ui'
// import router from '@/router'
const httpRequest = axios.create({
  baseURL: import.meta.env.VITE_BASE_URL,
  timeout: 60000,
  withCredentials: true,
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded'
    // tenant: 'x1'
  }
})

// 请求拦截
httpRequest.interceptors.request.use(
  function (config) {
    if (config.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
      config.data = qs.stringify(config.data)
    }
    return config
  },
  function (error) {
    return Promise.reject(error)
  }
)

// 响应拦截
httpRequest.interceptors.response.use(
  function (response) {
    const { data, config } = response
    // if (config.url.indexOf('education/certificate') !== -1) {
    //   return data
    // } else {
    //   if (data.code === 0) {
    //     return data
    //   } else {
    //     Message.error(data.msg || data.message)
    //     return Promise.reject(data)
    //   }
    //   return data
    // }
    if (config.url.indexOf('education/certificate') !== -1) {
      return data
    }
    if (data.code) {
      Message.error(data.msg || data.message)
      return Promise.reject(data)
    }
    return data
  },
  function (error) {
    if (error.response) {
      const { status, message } = error.response.data
      // 未登录
      if (status === 403) {
        window.location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(window.location.href)}`
      } else if (status === 401) {
        // Message.error('未授权请从新登陆')
        // setTimeout(() => {
        //   window.location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(window.location.href)}`
        // }, 1000)
      } else {
        Message.error(message || error.response.data)
      }
      return Promise.reject(error.response)
    } else {
      Message.error(error)
    }
    return Promise.reject(error)
  }
)

export default httpRequest
