import store from '@/store'

export default async function (to, from, next) {
  const { user_id: userId, student_id: studentId } = to.query
  if (userId && studentId) {
    store.commit('setGuestUser', { user_id: userId, student_id: studentId })
  }
  // 创建游客用户
  // await store.dispatch('createGuestUser')

  // 登录白名单
  const whiteList = ['/index']
  if (whiteList.includes(to.path)) {
    next()
    return
  }

  const isLogin = store.state.isLogin || (await store.dispatch('checkLogin'))
  if (to.meta.requiredLogin && !isLogin) {
    window.location.href = `${import.meta.env.VITE_LOGIN_URL}?rd=${encodeURIComponent(window.location.href)}`
    return
  }
  next()
}
