import fs from 'fs'
import path from 'path'
import { defineConfig } from 'vite'
import { createVuePlugin } from 'vite-plugin-vue2'
import eslint from '@rollup/plugin-eslint'
export default defineConfig({
  base: process.env.BUILD_ENV === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/fd-learn/' : '/',
  plugins: [eslint({ include: '**/*.+(vue|js|jsx|ts|tsx)' }), createVuePlugin()],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.key')),
      cert: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.pem'))
    },
    proxy: {
      // '/api/lms-financial': 'http://localhost-financial-api.ezijing.com'
      // '/api/lms-financial': {
      //   target: 'http://localhost-financial-api.ezijing.com',
      //   changeOrigin: true,
      //   rewrite: path => path.replace(/^\/api\/fd/, '')
      // }
    }
  },
  resolve: {
    alias: [
      {
        find: '@',
        replacement: path.resolve(__dirname, 'src')
      }
    ]
  },
  css: {
    // 禁用SASS警告提醒
    preprocessorOptions: { scss: { quietDeps: true } }
  }
})
