import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程详情
 * @param {string} semesterId 学期ID
 * @param {string} courseId 课程ID
 */
export function getCourse(semesterId, courseId) {
  return httpRequest.get(`/api/lms/v2/education/courses/${semesterId}/${courseId}`)
}

/**
 * 获取讨论题目列表，“我提出的问题”和“我参与的问题”信息
 * dataJson.limit - 获取数量
 * dataJson.offset - 偏移量
 * @param {[string]} path
 * @param {[object]} dataJson
 */
export function getDiscussList(qid, params) {
  return httpRequest.get(`/api/lms/v2/qa/questions/${qid}`, params)
}

/**
 * 获取讨论题目列表，“课程的问题”信息
 * dataJson.limit - 获取数量
 * dataJson.offset - 偏移量
 * dataJson.sort - 排序类型
 * @param {[string]} cid
 * @param {[string]} sid
 * @param {[object]} dataJson
 */
export function getCourseDiscussList(sid, cid, params) {
  return httpRequest.get(`/api/lms/v2/qa/questions/course/${sid}/${cid}`, { params })
}
/**
 * 获取问题详情
 * @param {[string]} qid
 */
export function getDiscussDetail(qid) {
  return httpRequest.get(`/api/lms/v2/qa/questions/${qid}`, {})
}
/**
 * 删除提问
 * @param {[string]} qid
 */
export function deleteDiscuss(qid) {
  return httpRequest.delete(`/api/lms/v2/qa/questions/${qid}`, {})
}
/**
 * 提出问题
 * @param {[object]} param
 */
export function publishQues(param) {
  return httpRequest.post('/api/lms/v2/qa/questions', param, { headers: { 'Content-Type': 'application/json' } })
}
/**
 * 回答问题
 * @param {[object]} param
 */
export function answerQues(param) {
  return httpRequest.post('/api/lms/v2/qa/answers', param, { headers: { 'Content-Type': 'application/json' } })
}
/**
 * 删除回答
 * @param {[string]} aid
 */
export function deleteAnswer(aid) {
  return httpRequest.delete(`/api/lms/v2/qa/answers/${aid}`, {})
}
/**
 * 回复评论
 * @param {[object]} param
 */
export function callbackComment(param) {
  return httpRequest.post('/api/lms/v2/qa/comments', param, { headers: { 'Content-Type': 'application/json' } })
}
/**
 * 删除评论
 * @param {[string]} cid
 */
export function deleteComment(cid) {
  return httpRequest.delete(`/api/lms/v2/qa/comments/${cid}`)
}
/**
 * 点赞
 * @param {[object]} param
 */
export function like(param) {
  return httpRequest.post('/api/lms/v2/qa/tags', param, { headers: { 'Content-Type': 'application/json' } })
}
/**
 * 取消点赞
 * @param {[string]} tagid
 */
export function unlike(tagid) {
  return httpRequest.delete(`/api/lms/v2/qa/tags/${tagid}`, {})
}
