import Offices from './src/index.vue'
import Routes from './routes'
import zhCN from './languages/zh-CN'
import en from './languages/en'

Offices.install = function(Vue, opts = {}) {
  // 国际化
  if (opts.i18n) {
    opts.i18n.mergeLocaleMessage('zh-CN', zhCN)
    opts.i18n.mergeLocaleMessage('en', en)
  }
  // 路由
  if (opts.router) {
    opts.router.addRoutes(Routes)
  }
}
export default Offices
