import BaseAPI from '../base_api'

export default class CourseAPI extends BaseAPI {
  /**
   * 获取学期分类信息
   */
  getlearnFindList = () => this.get('/ep/v2/education/semesters', {})
  /**
   * 获取所有课程列表 - 选课广场 和 我的课程 共用同一个,通过 isMy判断
   * @param {[string]} isMy
   * @param {[object]} param
   */
  getCourseList = (isMy, param) => this.get('/ep/v2/education/courses' + (isMy ? '/my' : ''), param)
  /**
   * 获取某个课程详细信息 - 课程考核 和 课程讨论单独获取
   * @param {[string]} id
   */
  getCourseDetail = (id, sid) => this.get(`/ep/v2/education/courses/${id}`, {})
  /**
   * 获取课程考核信息
   * @param {[string]} cid
   */
  getCourseAssess = (cid, sid) => this.get(`/ep/v2/analytics/courses/${cid}/evaluation`, {})
  /**
   * 选课
   * @param {[string]} cid
   */
  selectCourse = (cid, sid) => this.post(`/ep/v2/education/courses/major`, { course_id: cid })
  /**
   * 退课
   * @param {[string]} cid
   */
  outSelectCourse = (cid, sid) => this.post(`/ep/v2/education/courses/drop`, { course_id: cid })
}
