import { uploadFile } from '@/api/common'

export default function(blobInfo, succFun, failFun) {
  const file = blobInfo.blob()
  uploadFile({ file })
    .then(response => {
      response.success ? succFun(response.url) : failFun(response.message)
    })
    .catch(response => {
      failFun(response.message)
    })
}
