import Discuss from './discuss'
import Viewer from './viewer'
import Offices from './offices'

const components = [Discuss, Viewer, Offices]

const install = function(Vue, opts = {}) {
  components.forEach(component => {
    Vue.use(component, opts)
  })
}

/* istanbul ignore if */
if (typeof window !== 'undefined' && window.Vue) {
  install(window.Vue)
}

export default { install, ...components }
