import Vue from 'vue'
import Router from 'vue-router'
import routes from './routes'

Vue.use(Router)
const originalPush = Router.prototype.push
Router.prototype.push = function push(location, onResolve, onReject) {
  if (onResolve || onReject) return originalPush.call(this, location, onResolve, onReject)
  return originalPush.call(this, location).catch(err => err)
}
export default new Router({
  routes,
  mode: 'history', // 还有一个 hash 默认
  fallback: true, // 浏览器不支持 history时，自动改成 hash方式
  scrollBehavior(to, from, savedPosition) {
    // 每次打开，滚动到 最顶端
    return { x: 0, y: 0 }
  }
})
